set more off
set matsize 1000

use table2_cps-panel-final.dta, clear

* Data for all states available only since 1978
keep if year>=1978

* Create population weights, average over 1978-2013
sort year state
by year: egen totpop=sum(pop)
gen pop_sh=pop/totpop
bysort state: egen pop_sh_ave=mean(pop_sh)
drop totpop pop_sh

* Create state time trends
quietly tab state, gen(statedum)
quietly for num 1/51: replace statedumX=statedumX*year

* BLS pub unemp rate
local ur2014Q2=6.219
local ur2013Q2=7.524
local ur2012Q2=8.177
local ur2011Q2=9.075
local ur2010Q2=9.661
local ur2009Q2=9.280
local ur2008Q2=5.321

* CBO natural rate
local nr2014Q2=5.500
local nr2013Q2=5.450
local nr2012Q2=5.320
local nr2011Q2=5.260
local nr2010Q2=5.180
local nr2009Q2=5.050
local nr2008Q2=5.000

* UR gap
local gap0=`ur2014Q2'-`nr2014Q2'
local gap1=`ur2013Q2'-`nr2013Q2'
local gap2=`ur2012Q2'-`nr2012Q2'
local gap3=`ur2011Q2'-`nr2011Q2'
local gap4=`ur2010Q2'-`nr2010Q2'
local gap5=`ur2009Q2'-`nr2009Q2'
local gap6=`ur2008Q2'-`nr2008Q2'


* Panel regressions
xtset state year, y

* Column 1 
xtreg lfpr statedum* sh* i.year ur [aweight=pop_sh_ave], fe vce(cluster state)

nlcom _b[ur]*`gap0'
mat C1=r(b)
local c1=C1[1,1]

# delimit ;
outreg2 using Table2.doc, append ctitle(1978-2013) keep(ur) nocons 
addtext(Total cyclical effect, `=string(_b[ur], "%4.2f")'***, SE of cyclical effect, `=string(_se[ur], "%4.2f")', 
Implied cyclical shortfall in 2014:Q2, `=string(`c1', "%4.2f")',
Demog. controls, YES, State trends, YES) dec(2);
# delimit cr


* Column 2
xtreg lfpr statedum* sh* i.year l(0/3).ur [aweight=pop_sh_ave], fe vce(cluster state)

nlcom _b[ur]+_b[l1.ur]+_b[l2.ur]+_b[l3.ur]
mat B1=r(b)
local b1=B1[1,1]
mat B2=r(V)
local b2=sqrt(B2[1,1])

nlcom _b[ur]*`gap0'+_b[l1.ur]*`gap1'+_b[l2.ur]*`gap2'+_b[l3.ur]*`gap3'
mat C1=r(b)
local c1=C1[1,1]

# delimit ;
outreg2 using Table2.doc, append ctitle(1978-2013) keep(l(0/3).ur) nocons 
addtext(Total cyclical effect, `=string(`b1', "%4.2f")'***, SE of cyclical effect, `=string(`b2', "%4.2f")', 
Implied cyclical shortfall in 2014:Q2, `=string(`c1', "%4.2f")',
Demog. controls, YES, State trends, YES) dec(2);
# delimit cr


* Column 3
xtreg lfpr statedum* sh* i.year l1.lfpr l(0/3).ur [aweight=pop_sh_ave], fe vce(cluster state)

nlcom (_b[ur]+_b[l1.ur]+_b[l2.ur]+_b[l3.ur])/(1-_b[l1.lfpr])
mat B1=r(b)
local b1=B1[1,1]
mat B2=r(V)
local b2=sqrt(B2[1,1])

# delimit ;
nlcom                                 _b[ur]*`gap0'+_b[l1.ur]*`gap1'+_b[l2.ur]*`gap2'+_b[l3.ur]*`gap3' +
                         _b[l1.lfpr]*(_b[ur]*`gap1'+_b[l1.ur]*`gap2'+_b[l2.ur]*`gap3'+_b[l3.ur]*`gap4')+
             _b[l1.lfpr]*_b[l1.lfpr]*(_b[ur]*`gap2'+_b[l1.ur]*`gap3'+_b[l2.ur]*`gap4'+_b[l3.ur]*`gap5')+
 _b[l1.lfpr]*_b[l1.lfpr]*_b[l1.lfpr]*(_b[ur]*`gap3'+_b[l1.ur]*`gap4'+_b[l2.ur]*`gap5'+_b[l3.ur]*`gap6');
# delimit cr

mat C1=r(b)
local c1=C1[1,1]

# delimit ;
outreg2 using Table2.doc, append ctitle(1978-2013) keep(l1.lfpr  l(0/3).ur) nocons 
addtext(Total cyclical effect, `=string(`b1', "%4.2f")'***, SE of cyclical effect, `=string(`b2', "%4.2f")', 
Implied cyclical shortfall in 2014:Q2, `=string(`c1', "%4.2f")',
Demog. controls, YES, State trends, YES) dec(2);
# delimit cr


* Column 4
xtreg lfpr statedum* sh* i.year l1.lfpr l(0/3).ur [aweight=pop_sh_ave] if year>=1990, fe vce(cluster state)

nlcom (_b[ur]+_b[l1.ur]+_b[l2.ur]+_b[l3.ur])/(1-_b[l1.lfpr])
mat B1=r(b)
local b1=B1[1,1]
mat B2=r(V)
local b2=sqrt(B2[1,1])

# delimit ;
nlcom                                 _b[ur]*`gap0'+_b[l1.ur]*`gap1'+_b[l2.ur]*`gap2'+_b[l3.ur]*`gap3' +
                         _b[l1.lfpr]*(_b[ur]*`gap1'+_b[l1.ur]*`gap2'+_b[l2.ur]*`gap3'+_b[l3.ur]*`gap4')+
             _b[l1.lfpr]*_b[l1.lfpr]*(_b[ur]*`gap2'+_b[l1.ur]*`gap3'+_b[l2.ur]*`gap4'+_b[l3.ur]*`gap5')+
 _b[l1.lfpr]*_b[l1.lfpr]*_b[l1.lfpr]*(_b[ur]*`gap3'+_b[l1.ur]*`gap4'+_b[l2.ur]*`gap5'+_b[l3.ur]*`gap6');
# delimit cr

mat C1=r(b)
local c1=C1[1,1]

# delimit ;
outreg2 using Table2.doc, append ctitle(1990-2013) keep(l1.lfpr  l(0/3).ur) nocons 
addtext(Total cyclical effect, `=string(`b1', "%4.2f")'***, SE of cyclical effect, `=string(`b2', "%4.2f")', 
Implied cyclical shortfall in 2014:Q2, `=string(`c1', "%4.2f")',
Demog. controls, YES, State trends, YES) dec(2);
# delimit cr


* Column 5
xtreg lfpr statedum* sh* i.year l1.lfpr l(0/3).ur [aweight=pop_sh_ave] if year<=2007, fe vce(cluster state)

nlcom (_b[ur]+_b[l1.ur]+_b[l2.ur]+_b[l3.ur])/(1-_b[l1.lfpr])
mat B1=r(b)
local b1=B1[1,1]
mat B2=r(V)
local b2=sqrt(B2[1,1])

# delimit ;
nlcom                                 _b[ur]*`gap0'+_b[l1.ur]*`gap1'+_b[l2.ur]*`gap2'+_b[l3.ur]*`gap3' +
                         _b[l1.lfpr]*(_b[ur]*`gap1'+_b[l1.ur]*`gap2'+_b[l2.ur]*`gap3'+_b[l3.ur]*`gap4')+
             _b[l1.lfpr]*_b[l1.lfpr]*(_b[ur]*`gap2'+_b[l1.ur]*`gap3'+_b[l2.ur]*`gap4'+_b[l3.ur]*`gap5')+
 _b[l1.lfpr]*_b[l1.lfpr]*_b[l1.lfpr]*(_b[ur]*`gap3'+_b[l1.ur]*`gap4'+_b[l2.ur]*`gap5'+_b[l3.ur]*`gap6');
# delimit cr

mat C1=r(b)
local c1=C1[1,1]

# delimit ;
outreg2 using Table2.doc, append ctitle(1978-2007) keep(l1.lfpr  l(0/3).ur) nocons 
addtext(Total cyclical effect, `=string(`b1', "%4.2f")'***, SE of cyclical effect, `=string(`b2', "%4.2f")', 
Implied cyclical shortfall in 2014:Q2, `=string(`c1', "%4.2f")',
Demog. controls, YES, State trends, YES) dec(2);
# delimit cr
